

/******************************************************************************************
 *                                                                                        *
 *  Ex1.     :  Read BCD ET-Matrix Key Decoder for Key PAD 4x4 and 4x3                    *
 *                  (Connect Key Pad 4x4 or 4x3 to KEY_IN1 or KEY_IN2)                    *
 *                                                                                        *
 ******************************************************************************************
 *                                                                                        *
  * Target MCU       : PIC18F8722 (ET-BASE PIC8722(ICD2))                                 *
 *                   : X-TAL : 10 MHz                                                     *
 *                   : CPU Clock = 40 MHz (x4)                                            *  
 *                                                                                        *
 * Editor-Compiler   : CCS Version 4.124                                                  *
 *                                                                                        *
 * Create By         : Mr. Sittiphol Yooyod (WWW.ETT.CO.TH)                               *
 * Last Update       : 13/April/2015                                                      *
 *                                                                                        *
 * I/P BCD Port      :  -- MCU-PIC-18F8722--              -- ET-Matrix Key Decoder --     *
 *                                                                                        *
 *                     PJ0(Input)          Connect                 BCD1                   * 
 *                     PJ1(Input)          Connect                 BCD2                   *
 *                     PJ2(Input)          Connect                 BCD4                   *
 *                     PJ3(Input)          Connect                 BCD8                   *
 *                     PJ4(Input)          Connect                 P#/R Ststus Key        *
 *                                                                                        * 
 * O/P Display Port  :                                                                    *
 *                                                                                        *
 *               LED : Connect Common Anode(LED Active Low)                               *
 *                     RB0              Connect                   LED0(BCD1)              *
 *                     RB1              Connect                   LED1(BCD2)              *  
 *                     RB2              Connect                   LED2(BCD4)              *
 *                     RB3              Connect                   LED3(BCD8)              *
 *                                                                                        *
 *                                                                             5V         *
 *                                                                           -+-          *
 *                                                              560      \\     |         *
 *                                                      RB0 --/\/\/\---|<|-----+          *
 *                                                                      .       |         *
 *                                                              560     . \\    |         *
 *                                                      RB3 --/\/\/\-----|<|---+          *
 *                                                                                        *
 *                                                                                        *
 *       UART1     :  RC6 = TX1          Connect              Rx PC                       *
 *                    RC7 = RX1          Connect              Tx PC                       *                                                                        *
 *                    Baud Rate = 9600  at Clock 40Mhz                                    *
 *                                                                                        *
 *                                                                                        *
 *  Operation  : When Touch Key will Show Key Code(Hex) on Heperterminal and LED RB[0..3] *  
 *                                                                                        *
 ******************************************************************************************/
 

#include <18F8722.h>
#include <stdio.h>

//#define TX1   PIN_C6
//#define RX1   PIN_C7

#fuses H4,NOLVP,NOWDT,NOPROTECT,NOSTVREN         //Setup MCU
#use delay (clock = 40000000)                    //delay Clock = (ms)
//#use rs232(baud = 9600, xmit = TX1, rcv = RX1) //Set Rs232
#use rs232(uart1,baud=9600,stream=ch1)           // Set Rs232 Hard ware  
#use fast_io(ALL)                                //Stop Set direction Auto for All Port  by Compiler  


int8 Check_PR(void)     ;
int8 RD_KeyCode(void)   ;
 

//*************************** Main *************************

void main (void) 
    {                               
     unsigned int8 key ;   
     
     //------------- Initial Port -----------
      set_tris_B(0x00)                ;        //Set RB(0..7) = Output for LED Display BCD Key code 
      set_tris_J(0xFF)                ;        //Set RJ(0..7) = Input for Read BCD Key Code
 
                
      OUTPUT_B(0xFF)                  ;       //Set data 0xFF Default RB = LED OFF  
      
     //---------initial Uart1 ------------

      set_tris_C(0x80)                ;        //Set RX(RC7) = In,TX(RC6)=Out,RC5..RC0 = Out
    
    //---------------- Main -----------------
    
    printf("*************************************************************************\r\n");    
    printf("**          Ex1.TEST READ BCD KEY CODE ET-Matrix Key Decoder           **\r\n");        
    printf("*************************************************************************\r\n"); 
  
    while(true)
     {
       if(!Check_PR())                             //Step1: Check  pressed key (Check_PR()=0:press,1:release) 
        {
         key = RD_KeyCode()                     ;  //Step2: Read Key Code

         //---------- Step3:Program Respond press key for user ------------
       
          OUTPUT_B(~key)                       ;   //Out Hex data BCD key Code to LED RB[0..3]
          printf("Key_Code BCD = 0x%X",key)    ;   //Print Key Code Out RS232 baudrate 9600
          printf("\n\r")                       ;

          while(!Check_PR()){;}                ; //Wait Release Key (=1 exit loop)
        }          
     }   //while
   }

//********************** Sub Program *************************

//---------------------- Check Touch /Release Key -------------------

int8 Check_PR(void)    
 {
   int8 pr   ;
        
      pr  = INPUT_J()             ;   //Read Status Key
      pr  = pr & 0x10             ;   //Mark bit PJ4 (Statust Press or Release)
   
    if(pr != 0x10)                    //Check Statue Key
      return (0)                  ;   //Press Key Return 0 (PJ4=0)
    else
      return (1)                  ;   //Release Key Return 1   (PJ4=1)
 }


//---------- Read BCD Key Code -----------------

 int8 RD_KeyCode(void) 
  {
    unsigned int8 KeyCode                  ;
  
    KeyCode      = INPUT_J()               ;   //Read Key Code
    KeyCode      = KeyCode & 0x0F          ;   //Mark bit PJ0-PJ3(Key Code 4 bit)
    return (KeyCode)                       ;
  }



